// PCW99_ODBC_OLTP_Write.cpp

#include "stdafx.h"
#include "PCW99_ODBC_Generic.h"
#include "PCW99_ODBC_Generic_OLTP_Write.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Write_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Write_05,CXact,1)

// ================================================================================

// CXact_OLTP_Write_01

CXact_OLTP_Write_01::CXact_OLTP_Write_01 (void)
{
	m_szName		= "OLTP Write 01";
	m_szDescription = "single table 1 row select and update on an int, 1 row insert";
	m_szSQL			= "(client-side routine)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+01;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_01::~CXact_OLTP_Write_01 (void)
{
}

BOOL CXact_OLTP_Write_01::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_01::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_01::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmtSelect, hstmtUpdate, hstmtInsert;
	SQLRETURN ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;
	SQLINTEGER oldint;
	SQLINTEGER oldint_ind;
	SQLUSMALLINT row_status_array[NUM_ROWS];
	BOOL bDataFound;
	SQLTCHAR *szCursorName;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	m_szSQL = "select updates.p_int from updates where updates.p_key = ? for update of p_int";
#else
	m_szSQL = "select updates.p_int from updates where updates.p_key = ?";
#endif

	// set connection settings
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_AUTOCOMMIT, (PTR)SQL_AUTOCOMMIT_OFF, IGNORE);
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_READ_COMMITTED, IGNORE);
	CHECK_FOR_ERROR (NULL);
#else
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_REPEATABLE_READ, IGNORE);
	CHECK_FOR_ERROR (NULL);
#endif
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oldint), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmtSelect);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmtSelect, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmtSelect);

	// bind input variables
	ReturnCode = SQLBindParameter (hstmtSelect, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR (hstmtSelect);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmtSelect, 1, SQL_C_SLONG, &oldint, sizeof(oldint), &oldint_ind);
	CHECK_FOR_ERROR (hstmtSelect);

	// set cursor name
	szCursorName = (SQLTCHAR *) malloc (strlen("oltp_write_01"));
	strcpy ((char *)szCursorName, "oltp_write_01");
	SQLSetCursorName (hstmtSelect, szCursorName, SQL_NTS);
	free (szCursorName);

	// ==========
	// select
	
	// initialize variables
	bDataFound = FALSE;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE-100);	// less than RANDBASE to prevent referential integrity failures

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmtSelect);
	CHECK_FOR_ERROR_EXECUTE (hstmtSelect);

	// fetch loop
	while (TRUE) {
		
		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				return FALSE;
		}
		
		// fetch the data
		ReturnCode = SQLFetchScroll (hstmtSelect, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmtSelect);

		// check if we found a row
		if (ReturnCode != SQL_NO_DATA) bDataFound = TRUE;

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< "oldint = " << oldint << endl;
			}

		// break out of the loop (if we loop again, the next SQLSetPos will fail)
		break;
	
	}

	if (bDataFound == TRUE) {
	
		// position the cursor and get the lock
		SQLSetPos (hstmtSelect, 0, SQL_POSITION, SQL_LOCK_EXCLUSIVE);
		CHECK_FOR_ERROR (hstmtSelect);

		// ==========
		// update
		
		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// initialize variables
#if (_USE_POSITIONED_UPDATES_ == TRUE)
		m_szSQL = "update updates set p_int = p_int + 1 where current of oltp_write_01";
#else
		m_szSQL.Format ("update updates set p_int = p_int + 1 where p_key = %ld", randbase);
#endif

		// prepare the statement
		ReturnCode = SQLPrepare (hstmtUpdate, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR (hstmtUpdate);

		// execute the statement
		ReturnCode = SQLExecute (hstmtUpdate);
		CHECK_FOR_ERROR_EXECUTE (hstmtUpdate);

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				return FALSE;
		}

		// ==========
		// insert
		
		// initialize variables
		CTime CurrentTime = CTime::GetCurrentTime();
		m_szSQL.Format ("insert into update_int_history values (%ld, %ld, %s)", randbase, oldint, CurrentTime.Format("{ts '%Y-%m-%d %H:%M:%S'}"));

		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);

		// execute the statement
		ReturnCode = SQLExecDirect (hstmtInsert, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR_EXECUTE (hstmtInsert);
		
		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
				CHECK_FOR_ERROR (hstmtInsert);
				return FALSE;
		}

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);
	
	}

	// commit transaction
	SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_COMMIT);
	CHECK_FOR_ERROR (hstmtSelect);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);
	
	// ==========

	// update statistics
	m_nUnits = 0;
	m_nBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_02

CXact_OLTP_Write_02::CXact_OLTP_Write_02 (void)
{
	m_szName		= "OLTP Write 02";
	m_szDescription = "single table 1 row select and update on an int, 1 row insert";
	m_szSQL			= "(client-side routine)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+02;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_02::~CXact_OLTP_Write_02 (void)
{
}

BOOL CXact_OLTP_Write_02::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_02::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_02::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmtSelect, hstmtUpdate, hstmtInsert;
	SQLRETURN ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;
	SQLINTEGER oldsigned;
	SQLINTEGER oldsigned_ind;
	SQLUSMALLINT row_status_array[NUM_ROWS];
	BOOL bDataFound;
	SQLTCHAR *szCursorName;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	m_szSQL = "select updates.p_signed from updates where updates.p_key = ? for update of p_signed";
#else
	m_szSQL = "select updates.p_signed from updates where updates.p_key = ?";
#endif

	// set connection settings
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_AUTOCOMMIT, (PTR)SQL_AUTOCOMMIT_OFF, IGNORE);
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_READ_COMMITTED, IGNORE);
	CHECK_FOR_ERROR (NULL);
#else
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_REPEATABLE_READ, IGNORE);
	CHECK_FOR_ERROR (NULL);
#endif
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oldsigned), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmtSelect);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmtSelect, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmtSelect);

	// bind input variables
	ReturnCode = SQLBindParameter (hstmtSelect, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR (hstmtSelect);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmtSelect, 1, SQL_C_SLONG, &oldsigned, sizeof(oldsigned), &oldsigned_ind);
	CHECK_FOR_ERROR (hstmtSelect);

	// set cursor name
	szCursorName = (SQLTCHAR *) malloc (strlen("oltp_write_02"));
	strcpy ((char *)szCursorName, "oltp_write_02");
	SQLSetCursorName (hstmtSelect, szCursorName, SQL_NTS);
	free (szCursorName);

	// ==========
	// select
	
	// initialize variables
	bDataFound = FALSE;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE-100);	// less than RANDBASE to prevent referential integrity failures

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmtSelect);
	CHECK_FOR_ERROR_EXECUTE (hstmtSelect);

	// fetch loop
	while (TRUE) {
		
		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				return FALSE;
		}
		
		// fetch the data
		ReturnCode = SQLFetchScroll (hstmtSelect, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmtSelect);

		// check if we found a row
		if (ReturnCode != SQL_NO_DATA) bDataFound = TRUE;

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< "oldsigned = " << oldsigned << endl;
			}

		// break out of the loop (if we loop again, the next SQLSetPos will fail)
		break;
	
	}

	if (bDataFound == TRUE) {
	
		// position the cursor and get the lock
		SQLSetPos (hstmtSelect, 0, SQL_POSITION, SQL_LOCK_EXCLUSIVE);
		CHECK_FOR_ERROR (hstmtSelect);

		// ==========
		// update
		
		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// initialize variables
#if (_USE_POSITIONED_UPDATES_ == TRUE)
		m_szSQL = "update updates set p_signed = p_signed + 1 where current of oltp_write_02";
#else
		m_szSQL.Format ("update updates set p_signed = p_signed + 1 where p_key = %ld", randbase);
#endif

		// prepare the statement	
		ReturnCode = SQLPrepare (hstmtUpdate, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR (hstmtUpdate);

		// execute the statement
		ReturnCode = SQLExecute (hstmtUpdate);
		CHECK_FOR_ERROR_EXECUTE (hstmtUpdate);

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				return FALSE;
		}

		// ==========
		// insert
		
		// initialize variables
		CTime CurrentTime = CTime::GetCurrentTime();
		m_szSQL.Format ("insert into update_signed_history values (%ld, %ld, %s)", randbase, oldsigned, CurrentTime.Format("{ts '%Y-%m-%d %H:%M:%S'}"));

		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);

		// execute the statement
		ReturnCode = SQLExecDirect (hstmtInsert, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR_EXECUTE (hstmtInsert);
		
		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
				CHECK_FOR_ERROR (hstmtInsert);
				return FALSE;
		}

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);
	
	}

	// commit transaction
	SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_COMMIT);
	CHECK_FOR_ERROR (hstmtSelect);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);
	
	// ==========

	// update statistics
	m_nUnits = 0;
	m_nBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_03

CXact_OLTP_Write_03::CXact_OLTP_Write_03 (void)
{
	m_szName		= "OLTP Write 03";
	m_szDescription = "single row select and insert, single row delete";
	m_szSQL			= "(client-side routine)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+03;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_03::~CXact_OLTP_Write_03 (void)
{
}

BOOL CXact_OLTP_Write_03::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_03::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_03::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmtSelect, hstmtDelete, hstmtInsert;
	SQLRETURN ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randfivemill;
	struct OLTP_WRITE_03 {
		SQLINTEGER h_key;
		SQLINTEGER h_int;
		SQLINTEGER h_signed;
		SQLREAL h_float;
		SQLREAL h_double;
		SQLREAL h_decim;
		SQLCHAR h_date[35];
		SQLCHAR h_code[15];
		SQLCHAR h_name[25];
		SQLCHAR h_address[85];
	};
	typedef struct OLTP_WRITE_03 OLTP_WRITE_03;
	struct OLTP_WRITE_03_INDICATORS {
		SQLINTEGER h_key;
		SQLINTEGER h_int;
		SQLINTEGER h_signed;
		SQLINTEGER h_float;
		SQLINTEGER h_double;
		SQLINTEGER h_decim;
		SQLINTEGER h_date;
		SQLINTEGER h_code;
		SQLINTEGER h_name;
		SQLINTEGER h_address;
	};
	typedef struct OLTP_WRITE_03_INDICATORS OLTP_WRITE_03_INDICATORS;
	OLTP_WRITE_03 oltp_write_03_array[NUM_ROWS];
	OLTP_WRITE_03_INDICATORS oltp_write_03_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];
	BOOL bDataFound;
	SQLTCHAR *szCursorName;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	m_szSQL = "select h_key, h_int, h_signed, h_float, h_decim, h_decim, h_date, h_code, h_name, h_address from fivemill where fivemill.h_key = ? for update";
#else
	m_szSQL = "select h_key, h_int, h_signed, h_float, h_decim, h_decim, h_date, h_code, h_name, h_address from fivemill where fivemill.h_key = ?";
#endif

	// set connection settings
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_AUTOCOMMIT, (PTR)SQL_AUTOCOMMIT_OFF, IGNORE);
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_READ_COMMITTED, IGNORE);
	CHECK_FOR_ERROR (NULL);
#else
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_REPEATABLE_READ, IGNORE);
	CHECK_FOR_ERROR (NULL);
#endif
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// set statement attributes
 	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_write_03_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmtSelect);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmtSelect, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmtSelect);

	// bind input variables
	ReturnCode = SQLBindParameter (hstmtSelect, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfivemill, sizeof(randfivemill), &BindParamInd);
	CHECK_FOR_ERROR (hstmtSelect);

	// bind output variables
	ReturnCode = SQLBindCol (hstmtSelect, 1, SQL_C_SLONG, &oltp_write_03_array[0].h_key, sizeof(oltp_write_03_array[0].h_key), &oltp_write_03_indicators_array[0].h_key);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 2, SQL_C_SLONG, &oltp_write_03_array[0].h_int, sizeof(oltp_write_03_array[0].h_int), &oltp_write_03_indicators_array[0].h_int);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 3, SQL_C_SLONG, &oltp_write_03_array[0].h_signed, sizeof(oltp_write_03_array[0].h_signed), &oltp_write_03_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 4, SQL_C_FLOAT, &oltp_write_03_array[0].h_float, sizeof(oltp_write_03_array[0].h_float), &oltp_write_03_indicators_array[0].h_float);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 5, SQL_C_FLOAT, &oltp_write_03_array[0].h_double, sizeof(oltp_write_03_array[0].h_double), &oltp_write_03_indicators_array[0].h_double);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 6, SQL_C_FLOAT, &oltp_write_03_array[0].h_decim, sizeof(oltp_write_03_array[0].h_decim), &oltp_write_03_indicators_array[0].h_decim);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 7, SQL_C_CHAR, &oltp_write_03_array[0].h_date, sizeof(oltp_write_03_array[0].h_date), &oltp_write_03_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 8, SQL_C_CHAR, &oltp_write_03_array[0].h_code, sizeof(oltp_write_03_array[0].h_code), &oltp_write_03_indicators_array[0].h_code);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 9, SQL_C_CHAR, &oltp_write_03_array[0].h_name, sizeof(oltp_write_03_array[0].h_name), &oltp_write_03_indicators_array[0].h_name);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindCol (hstmtSelect, 10, SQL_C_CHAR, &oltp_write_03_array[0].h_address, sizeof(oltp_write_03_array[0].h_address), &oltp_write_03_indicators_array[0].h_address);
	CHECK_FOR_ERROR (hstmtSelect);

	// set cursor name
	szCursorName = (SQLTCHAR *) malloc (strlen("oltp_write_03"));
	strcpy ((char *)szCursorName, "oltp_write_03");
	SQLSetCursorName (hstmtSelect, szCursorName, SQL_NTS);
	free (szCursorName);

	// ==========
	// select
	
	// initialize variables
	bDataFound = FALSE;
	randfivemill = (long) m_CRandom.GetRandom(2,RANDFIVEMILL);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmtSelect);
	CHECK_FOR_ERROR_EXECUTE (hstmtSelect);

	// fetch loop
	while (TRUE) {
		
		// fetch the data
		ReturnCode = SQLFetchScroll (hstmtSelect, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmtSelect);

		// check if we found a row
		if (ReturnCode != SQL_NO_DATA) bDataFound = TRUE;

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< oltp_write_03_array[0].h_key << tab
				<< oltp_write_03_array[0].h_int << tab
				<< oltp_write_03_array[0].h_signed << tab
				<< oltp_write_03_array[0].h_float << tab
				<< oltp_write_03_array[0].h_double << tab
				<< oltp_write_03_array[0].h_decim << tab
				<< oltp_write_03_array[0].h_date << tab
				<< oltp_write_03_array[0].h_code << tab
				<< oltp_write_03_array[0].h_name << tab
				<< oltp_write_03_array[0].h_address << endl;
			}
	
		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				return FALSE;
		}
		
		// break out of the loop (if we loop again, the next SQLSetPos will fail
		break;

	}

	if (bDataFound == TRUE) {
	
		// position the cursor and get the lock
		SQLSetPos (hstmtSelect, 0, SQL_POSITION, SQL_LOCK_EXCLUSIVE);
		CHECK_FOR_ERROR (hstmtSelect);

		// ==========
		// delete
		
		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtDelete);
		CHECK_FOR_ERROR (hstmtDelete);

		// initialize variables
#if (_USE_POSITIONED_UPDATES_ == TRUE)
		m_szSQL = "delete from fivemill where current of oltp_write_03";
#else
		m_szSQL.Format ("delete from fivemill where fivemill.h_key = %ld", randfivemill);
#endif

		// prepare the statement	
		ReturnCode = SQLPrepare (hstmtDelete, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR (hstmtDelete);

		// execute the statement
		ReturnCode = SQLExecute (hstmtDelete);
		CHECK_FOR_ERROR_EXECUTE (hstmtDelete);
		
		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

			// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtDelete);
				CHECK_FOR_ERROR (hstmtDelete);
				return FALSE;
		}

		// ==========
		// insert
		
		// truncate string date value to produce 'yyyy-mm-dd' form
		oltp_write_03_array[0].h_date[10] = 0;
		
		// initialize variables
		m_szSQL.Format ("insert into del_history values (%ld, %ld, %ld, %f, %f, %f, {d '%s'}, '%s', '%s', '%s')", 
			oltp_write_03_array[0].h_key,
			oltp_write_03_array[0].h_int,
			oltp_write_03_array[0].h_signed,
			oltp_write_03_array[0].h_float,
			oltp_write_03_array[0].h_double,
			oltp_write_03_array[0].h_decim,
			oltp_write_03_array[0].h_date,
			oltp_write_03_array[0].h_code,
			oltp_write_03_array[0].h_name,
			oltp_write_03_array[0].h_address);

		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);

		// execute the statement
		ReturnCode = SQLExecDirect (hstmtInsert, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR_EXECUTE (hstmtInsert);

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtDelete);
				CHECK_FOR_ERROR (hstmtDelete);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
				CHECK_FOR_ERROR (hstmtInsert);
				return FALSE;
		}

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtDelete);
		CHECK_FOR_ERROR (hstmtDelete);

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtInsert);
		CHECK_FOR_ERROR (hstmtInsert);

	}

	// commit transaction
	SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_COMMIT);
	CHECK_FOR_ERROR (hstmtSelect);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// ==========

	// update statistics
	m_nUnits = 0;
	m_nBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_04

CXact_OLTP_Write_04::CXact_OLTP_Write_04 (void)
{
	m_szName		= "OLTP Write 04";
	m_szDescription = "single table in range select and update on 2 character fields, 1 int field";
	m_szSQL			= "(client-side routine)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+04;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_04::~CXact_OLTP_Write_04 (void)
{
}

BOOL CXact_OLTP_Write_04::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_04::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_04::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmtSelect, hstmtUpdate, hstmtUpdate2;
	SQLRETURN ReturnCode;
	SQLINTEGER BindParamInd;
	SQLINTEGER BindParamInd2;
	unsigned long randfourmill;
	unsigned long randfourmillplus;
	SQLINTEGER numupdates;
	SQLINTEGER numupdates_ind;
	SQLUSMALLINT row_status_array[NUM_ROWS];
	BOOL bDataFound;
	SQLTCHAR *szCursorName;

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	m_szSQL = "select count(*) from fourmill where (fourmill.t_key between ? and ?) and (fourmill.t_name <> 'NewName') for update";
#else
	m_szSQL = "select count(*) from fourmill where (fourmill.t_key between ? and ?) and (fourmill.t_name <> 'NewName')";
#endif

	// set connection settings
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_AUTOCOMMIT, (PTR)SQL_AUTOCOMMIT_OFF, IGNORE);
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_READ_COMMITTED, IGNORE);
	CHECK_FOR_ERROR (NULL);
#else
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_REPEATABLE_READ, IGNORE);
	CHECK_FOR_ERROR (NULL);
#endif

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(numupdates), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLSetStmtAttr (hstmtSelect, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmtSelect);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmtSelect, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmtSelect);

	// bind input variables
	ReturnCode = SQLBindParameter (hstmtSelect, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfourmill, sizeof(randfourmill), &BindParamInd);
	CHECK_FOR_ERROR (hstmtSelect);
	ReturnCode = SQLBindParameter (hstmtSelect, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfourmillplus, sizeof(randfourmillplus), &BindParamInd2);
	CHECK_FOR_ERROR (hstmtSelect);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmtSelect, 1, SQL_C_SLONG, &numupdates, sizeof(numupdates), &numupdates_ind);
	CHECK_FOR_ERROR (hstmtSelect);

	// set cursor name
	szCursorName = (SQLTCHAR *) malloc (strlen("oltp_write_04"));
	strcpy ((char *)szCursorName, "oltp_write_04");
	SQLSetCursorName (hstmtSelect, szCursorName, SQL_NTS);
	free (szCursorName);

	// ==========
	// select
	
	// initialize variables
	bDataFound = FALSE;
	randfourmill = (long) m_CRandom.GetRandom(2,RANDFOURMILL);
	randfourmillplus = randfourmill + 500;
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmtSelect);
	CHECK_FOR_ERROR_EXECUTE (hstmtSelect);

	// fetch loop
	while (TRUE) {
		
		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				return FALSE;
		}
		
		// fetch the data
		ReturnCode = SQLFetchScroll (hstmtSelect, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmtSelect);

		// check if we found a row
		if (ReturnCode != SQL_NO_DATA) bDataFound = TRUE;

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< "numupdates = " << numupdates << endl;
			}

		// break out of the loop (if we loop again, the next SQLSetPos will fail)
		break;
	
	}

	if (bDataFound == TRUE) {
	
		// position the cursor and get the lock
		SQLSetPos (hstmtSelect, 0, SQL_POSITION, SQL_LOCK_EXCLUSIVE);
		CHECK_FOR_ERROR (hstmtSelect);

		// ==========
		// update fourmill
		
		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// initialize variables
#if (_USE_POSITIONED_UPDATES_ == TRUE)
		m_szSQL = "update fourmill set t_name = 'NewName', t_address = 'New Address 320B Lakeside Dr., Foster City, CA' where current of oltp_write_04";
#else
		m_szSQL.Format ("update fourmill set t_name = 'NewName', t_address = 'New Address 320B Lakeside Dr., Foster City, CA' where (fourmill.t_key between %ld and %ld) and (fourmill.t_name <> 'NewName')", randfourmill, randfourmillplus);
#endif

		// prepare the statement	
		ReturnCode = SQLPrepare (hstmtUpdate, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR (hstmtUpdate);

		// execute the statement
		ReturnCode = SQLExecute (hstmtUpdate);
		CHECK_FOR_ERROR_EXECUTE (hstmtUpdate);

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				return FALSE;
		}

		// ==========
		// update oltp_write_04_count_updates
		
		// allocate a statement handle
		ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtUpdate2);
		CHECK_FOR_ERROR (hstmtUpdate2);

		// initialize variables
		m_szSQL.Format ("update oltp_write_04_count_updates set num_updates = num_updates + %ld", numupdates);

		// prepare the statement
		ReturnCode = SQLPrepare (hstmtUpdate2, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
		m_szSQL.ReleaseBuffer();
		CHECK_FOR_ERROR (hstmtUpdate2);

		// execute the statement
		ReturnCode = SQLExecute (hstmtUpdate2);
		CHECK_FOR_ERROR_EXECUTE (hstmtUpdate2);

		// output data to log if requested
		if (OutputResults()) {
			GetResultsFile() 
				<< m_szSQL << endl;
		}

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
				CHECK_FOR_ERROR (hstmtSelect);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
				CHECK_FOR_ERROR (hstmtUpdate);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate2);
				CHECK_FOR_ERROR (hstmtUpdate2);
				return FALSE;
		}

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
		CHECK_FOR_ERROR (hstmtUpdate);

		// free handle
		ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate2);
		CHECK_FOR_ERROR (hstmtUpdate2);

	}

	// commit transaction
	SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_COMMIT);
	CHECK_FOR_ERROR (hstmtSelect);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtSelect);
	CHECK_FOR_ERROR (hstmtSelect);

	// ==========

	// update statistics
	m_nUnits = 0;
	m_nBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Write_05

CXact_OLTP_Write_05::CXact_OLTP_Write_05 (void)
{
	m_szName		= "OLTP Write 05";
	m_szDescription = "single table range update and rollback";
	m_szSQL			= "(client-side routine)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_WRITE+05;
	m_nGID			= OLTPWrite;
}

CXact_OLTP_Write_05::~CXact_OLTP_Write_05 (void)
{
}

BOOL CXact_OLTP_Write_05::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_05::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Write_05::Execute (void)
{
	
	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmtUpdate;
	SQLRETURN ReturnCode;
	SQLINTEGER BindParamInd;
	SQLINTEGER BindParamInd2;
	unsigned long randbase;
	unsigned long randbaseplus;
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	m_szSQL = "update updates set p_decim = p_decim - 2000000001 where p_key between ? and ?";

	// set connection settings
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_AUTOCOMMIT, (PTR)SQL_AUTOCOMMIT_OFF, IGNORE);
#if (_USE_POSITIONED_UPDATES_ == TRUE)
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_READ_COMMITTED, IGNORE);
	CHECK_FOR_ERROR (NULL);
#else
	ReturnCode = SQLSetConnectAttr (pSQLDatabaseServer->GetDatabaseHandle(), SQL_ATTR_TXN_ISOLATION, (PTR)SQL_TRANSACTION_REPEATABLE_READ, IGNORE);
	CHECK_FOR_ERROR (NULL);
#endif

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmtUpdate);
	CHECK_FOR_ERROR (hstmtUpdate);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmtUpdate, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmtUpdate);
	ReturnCode = SQLSetStmtAttr (hstmtUpdate, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmtUpdate);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmtUpdate, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmtUpdate);

	// bind input variables
	ReturnCode = SQLBindParameter (hstmtUpdate, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR (hstmtUpdate);
	ReturnCode = SQLBindParameter (hstmtUpdate, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbaseplus, sizeof(randbaseplus), &BindParamInd2);
	CHECK_FOR_ERROR (hstmtUpdate);
	
	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE);
	randbaseplus = randbase + 9;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmtUpdate);
	CHECK_FOR_ERROR_EXECUTE (hstmtUpdate);

	// check for user cancel
	if (CancelXact()) {
			m_CTimer.SetEndTime(m_nUnits, m_nBytes);
			SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
			CHECK_FOR_ERROR (hstmtUpdate);
			ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
			CHECK_FOR_ERROR (hstmtUpdate);
			return FALSE;
	}

	// output data to log if requested
	if (OutputResults()) {
		GetResultsFile() 
			<< m_szSQL << endl;
	}

	// rollback transaction
	SQLEndTran (SQL_HANDLE_DBC, pSQLDatabaseServer->GetDatabaseHandle(), SQL_ROLLBACK);
	CHECK_FOR_ERROR (hstmtUpdate);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmtUpdate);
	CHECK_FOR_ERROR (hstmtUpdate);

	// ==========

	// update statistics
	m_nUnits = 0;
	m_nBytes = 0;

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// return
	return TRUE;

}
